/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.quark;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.compat.quark.TransferMessage;
import vazkii.arl.network.IMessage;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.SortInventoryMessage;
import vazkii.quark.content.management.client.screen.widgets.MiniInventoryButton;
import vazkii.quark.content.management.module.EasyTransferingModule;
import vazkii.quark.content.management.module.InventorySortingModule;

public class QuarkButtonManager {
    private static final String KEY_MAPPING_PREFIX = "quark.keybind.";
    private static final Map<KeyMapping, Runnable> mappingsToCheck = new HashMap<KeyMapping, Runnable>();
    private static boolean mappingsInitialized = false;

    public static void addButtons() {
        int currentXOffset = -12;
        if (InventorySortingModule.enablePlayerInventoryInChests) {
            int finalCurrentXOffset = currentXOffset;
            StorageScreenBase.addButtonFactory(storageScreenBase -> {
                Position rightTopAbovePlayersInventory = storageScreenBase.getRightTopAbovePlayersInventory();
                return new MiniInventoryButton((AbstractContainerScreen)storageScreenBase, 0, rightTopAbovePlayersInventory.x() + finalCurrentXOffset, rightTopAbovePlayersInventory.y() - 1, "quark.gui.button.sort_inventory", b -> QuarkNetwork.sendToServer((IMessage)new SortInventoryMessage(true)));
            });
            currentXOffset -= 12;
        }
        int finalCurrentXOffset1 = currentXOffset;
        StorageScreenBase.addButtonFactory(storageScreenBase -> QuarkButtonManager.instantiateButton(storageScreenBase, 1, "insert", false, finalCurrentXOffset1));
        int finalCurrentXOffset2 = currentXOffset -= 12;
        StorageScreenBase.addButtonFactory(storageScreenBase -> QuarkButtonManager.instantiateButton(storageScreenBase, 2, "extract", true, finalCurrentXOffset2));
        currentXOffset -= 12;
        if (EasyTransferingModule.enableShiftLock) {
            int finalCurrentXOffset3 = currentXOffset;
            StorageScreenBase.addButtonFactory(storageScreenBase -> {
                Position rightTopAbovePlayersInventory = storageScreenBase.getRightTopAbovePlayersInventory();
                return new MiniInventoryButton((AbstractContainerScreen)storageScreenBase, 4, rightTopAbovePlayersInventory.x() + finalCurrentXOffset3, rightTopAbovePlayersInventory.y() - 1, "quark.gui.button.shift_lock", b -> {
                    EasyTransferingModule.shiftLocked = !EasyTransferingModule.shiftLocked;
                }).setTextureShift(() -> EasyTransferingModule.shiftLocked);
            });
        }
        MinecraftForge.EVENT_BUS.addListener(QuarkButtonManager::mouseInputEvent);
        MinecraftForge.EVENT_BUS.addListener(QuarkButtonManager::keyboardInputEvent);
    }

    private static Optional<KeyMapping> getKeyMapping(String mappingName) {
        for (KeyMapping keyMapping : Minecraft.m_91087_().f_91066_.f_92059_) {
            if (!keyMapping.m_90860_().equals(KEY_MAPPING_PREFIX + mappingName)) continue;
            return Optional.of(keyMapping);
        }
        return Optional.empty();
    }

    private static void mouseInputEvent(ScreenEvent.MouseClickedEvent.Pre pressed) {
        if (pressed.getScreen() instanceof StorageScreenBase) {
            QuarkButtonManager.initMappings();
            mappingsToCheck.forEach((mapping, toRun) -> {
                if (mapping.m_90830_(pressed.getButton()) && (mapping.getKeyModifier() == KeyModifier.NONE || mapping.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI))) {
                    toRun.run();
                    pressed.setCanceled(true);
                }
            });
        }
    }

    private static void initMappings() {
        if (mappingsInitialized) {
            return;
        }
        mappingsInitialized = true;
        if (InventorySortingModule.enablePlayerInventoryInChests) {
            QuarkButtonManager.getKeyMapping("sort_player").ifPresent(mapping -> mappingsToCheck.put((KeyMapping)mapping, () -> {
                if (InventorySortingModule.satisfyingClick) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                }
                QuarkNetwork.sendToServer((IMessage)new SortInventoryMessage(true));
            }));
        }
        QuarkButtonManager.getKeyMapping("transfer_insert").ifPresent(mapping -> mappingsToCheck.put((KeyMapping)mapping, () -> SophisticatedCore.PACKET_HANDLER.sendToServer(new TransferMessage(false, Screen.m_96638_()))));
        QuarkButtonManager.getKeyMapping("transfer_extract").ifPresent(mapping -> mappingsToCheck.put((KeyMapping)mapping, () -> SophisticatedCore.PACKET_HANDLER.sendToServer(new TransferMessage(true, Screen.m_96638_()))));
        if (EasyTransferingModule.enableShiftLock) {
            QuarkButtonManager.getKeyMapping("shift_lock").ifPresent(mapping -> mappingsToCheck.put((KeyMapping)mapping, () -> {
                EasyTransferingModule.shiftLocked = !EasyTransferingModule.shiftLocked;
            }));
        }
    }

    private static void keyboardInputEvent(ScreenEvent.KeyboardKeyPressedEvent.Post pressed) {
        if (pressed.getScreen() instanceof StorageScreenBase) {
            QuarkButtonManager.initMappings();
            mappingsToCheck.forEach((mapping, toRun) -> {
                if (mapping.m_90832_(pressed.getKeyCode(), pressed.getScanCode()) && (mapping.getKeyModifier() == KeyModifier.NONE || mapping.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI))) {
                    toRun.run();
                    pressed.setCanceled(true);
                }
            });
        }
    }

    private static AbstractButton instantiateButton(StorageScreenBase<?> screen, int priority, String name, boolean restock, int xOffset) {
        Position rightTopAbovePlayersInventory = screen.getRightTopAbovePlayersInventory();
        return new MiniInventoryButton(screen, priority, rightTopAbovePlayersInventory.x() + xOffset, rightTopAbovePlayersInventory.y() - 1, t -> t.add(I18n.m_118938_((String)("quark.gui.button." + name + (Screen.m_96638_() ? "_filtered" : "")), (Object[])new Object[0])), b -> SophisticatedCore.PACKET_HANDLER.sendToServer(new TransferMessage(restock, Screen.m_96638_()))).setTextureShift(Screen::m_96638_);
    }
}

